from flask_sqlalchemy import SQLAlchemy
from flask_login import UserMixin
from sqlalchemy import Index
from datetime import datetime


db = SQLAlchemy()


class User(UserMixin, db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String(80), unique=True, nullable=False)
    email = db.Column(db.String(120), unique=True, nullable=False)
    password = db.Column(db.String(255), nullable=False)
    confirmed = db.Column(db.Boolean, default=False)
    favorites = db.Column(db.JSON, nullable=True)
    created_date = db.Column(db.DateTime, nullable=False, default=datetime.utcnow)
    last_update = db.Column(db.DateTime, nullable=True)
    login_count = db.Column(db.Integer, default=0) 
    last_login = db.Column(db.DateTime, nullable=True)
    last_ip = db.Column(db.String(15), nullable=True)



class Call(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    json_transcript = db.Column(db.JSON)
    summary = db.Column(db.String(50000))
    companyname = db.Column(db.String(250))
    symbol = db.Column(db.String(10))
    date = db.Column(db.String(10))
    year = db.Column(db.String(4))
    quarter = db.Column(db.String(1))
    participants = db.relationship('Participant', back_populates='call', cascade="all, delete-orphan")
    __table_args__ = (Index('idx_date', 'date'),)


class Participant(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(250))
    role = db.Column(db.String(250))
    call_id = db.Column(db.Integer, db.ForeignKey('call.id'), nullable=False)
    call = db.relationship('Call', back_populates='participants')

    @staticmethod
    def call_exists(companyname, year, quarter):
        return db.session.query(Call).filter(
            and_(
                Call.companyname == companyname,
                Call.year == year,
                Call.quarter == quarter
            )
        ).first() is not None